 
 
#include "config.h"
 
volatile __16_type	gu16v_ADC_NTC;
volatile __16_type	gu16v_ADC_REF;
volatile u8			lu8v_RCWork_Mode;
volatile u16		gu16v_Rntc;
volatile __16_type	gu16v_Temp_MAX;
volatile __16_type	gu16v_Temp_MAX_Last;
volatile u8			gu8v_RC_Count;

volatile u8			lu8v_RCCorr_Mode;
volatile bit gbv_Temp_Lock;

volatile __16_type 		gu16v_correction_K;

void	fun_RC_Calibrate()
{
		static u16 lu16v_Vsen_buff;
		static u16 lu16v_Vsen_First;
		static u16 lu16v_Rntc_Max;
		static u16 lu16v_Rntc_Min;
		static u16 lu16v_Rntc_Sum;	
	 	static u8 lu8_Corr_Check_Data1;
	
	gbv_Flag_KEY_Halt_Enable=0;	
	switch(lu8v_RCCorr_Mode)
	{
		case 0:				
			fun_LCD_Full(0x00);		//	Clear  LCD
			LCD_Number_Display(37,0);
			gu16_CorrCount = 0;
			lu8v_RCCorr_Mode++;
		break;	
		case 1:
			gu16_CorrCount++;
			if(gu16_CorrCount>10)//
			{
				gu16_CorrCount= 0;
				lu8v_RCCorr_Mode++;
				gu8v_500msCount=0;
				lu16v_Vsen_First=0x00;
				gbv_Temp_Lock=0;
				lu16v_Rntc_Sum=0x00;
				lu16v_Rntc_Min=0xffff;
				lu16v_Rntc_Max=0x00;
				lu8_Corr_Check_Data1=0x55;
			}
		break;	
			
		case 2:
			mac_RCChan_REF();
			fun_RCInit();
			lu8v_RCCorr_Mode++;
		break;		
		case 3:
			if(_rtmrf)
			{
				_rtmrf = 0;
				gu16v_ADC_REF.byte.byte1 = _tmrbh;
				gu16v_ADC_REF.byte.byte0 = _tmrbl;
				
				mac_RCChan_NTC();
				fun_RCInit();
				lu8v_RCCorr_Mode++;
				
			}
		break;
		case 4:
			if(_rtmrf)
			{
				_rtmrf = 0;
				gu16v_ADC_NTC.byte.byte1 = _tmrbh;
				gu16v_ADC_NTC.byte.byte0 = _tmrbl;
				lu8v_RCCorr_Mode++;
			}
		break;
		case 5:
		{	
			volatile u16 lu16v_CorrTemp;
			lu8v_RCCorr_Mode=2;
			gu16v_Rntc = 3000*(u32)gu16v_ADC_REF.U16/(u32)gu16v_ADC_NTC.U16;
			fun_Vsen_Calculate();
			LCD_Number_Display(gu16v_Temp,3);
			lu16v_CorrTemp=abs(lu16v_Vsen_First - gu16v_Temp );
			if(lu16v_CorrTemp <= 10)//0.1℃
			{
				if(gbv_Temp_Lock)
				{
					lu16v_Rntc_Sum +=gu16v_Rntc;
					if(lu16v_Rntc_Max < gu16v_Rntc )
					{
						lu16v_Rntc_Max=gu16v_Rntc;
					}
					if(lu16v_Rntc_Min > gu16v_Rntc )
					{
						lu16v_Rntc_Min=gu16v_Rntc;
					}
					gu16_CorrCount++;
					if(gu16_CorrCount >3)//4 次
					{
						gu16_CorrCount=0;
						gu16v_Rntc=(lu16v_Rntc_Sum-lu16v_Rntc_Max-lu16v_Rntc_Min)>>1;
						
						lu16v_CorrTemp=abs(3700 - gu16v_Temp );
						if(lu16v_CorrTemp <300)
						{
					//--------------------------- 以37度校准得出K值 -------------------------------//								
							lu16v_Vsen_buff = gu16c_NTC_Table[17];
							gu16v_correction_K.U16 = (u32)lu16v_Vsen_buff*10000 / gu16v_Rntc;
							if( lu8_Corr_Check_Data1  == 0x55)
							{
								fun_eeprom_Write(0,gu16v_correction_K.byte.byte0);       //保存Rt 系?K
								fun_eeprom_Write(1,gu16v_correction_K.byte.byte1);								
							}
							if( lu8_Corr_Check_Data1  == 0x55)
							{
								fun_eeprom_Write(2,gu16v_correction_K.byte.byte0);       //保存Rt 系?K
								fun_eeprom_Write(3,gu16v_correction_K.byte.byte1);	
							}
							if( lu8_Corr_Check_Data1  == 0x55)
							{
								fun_eeprom_Write(4,gu16v_correction_K.byte.byte0);       //保存Rt 系?K
								fun_eeprom_Write(5,gu16v_correction_K.byte.byte1);							
							}					
							LCD_Number_Display(11,2);					
							gu8v_Beep_Mode=BEEP_1;
							GCC_CLRWDT();
							delay_n_ms(1000);
							gu8v_500msCount=0x00;
							GCC_CLRWDT();
							gu8v_SysMode = Halt_Mode;					
						}
					}					
				}
				else
				{
					gu16_CorrCount++;
					if(gu16_CorrCount >3)
					{
						gu16_CorrCount=0;
						gbv_Temp_Lock=1;
					}					
				}
				
			}
			else
			{
				gu16_CorrCount=0;
				gbv_Temp_Lock=0;	
				lu16v_Vsen_First=gu16v_Temp;
				lu16v_Rntc_Sum=0;
				lu16v_Rntc_Min=0xffff;
				lu16v_Rntc_Max=0x00;
			}
			if(gu8v_500msCount > 40)
			{
				LCD_Number_Display(00,2);
				gu8v_500msCount = 0;
				gu8v_Beep_Mode=BEEP_1_1_1;
				GCC_CLRWDT();
				delay_n_ms(1000);
				GCC_CLRWDT();
				gu8v_SysMode = Halt_Mode;
				
			}

		}
		break;
	}
}

void	fun_RCWork()
{
	gbv_Flag_KEY_Halt_Enable=SET;
	switch(lu8v_RCWork_Mode)
	{
		case 0:	
			
			mac_RCChan_REF();
			fun_RCInit();
			lu8v_RCWork_Mode++;
		break;		
		case 1:
			if(_rtmrf)
			{
				_rtmrf = 0;
				gu16v_ADC_REF.byte.byte1 = _tmrbh;
				gu16v_ADC_REF.byte.byte0 = _tmrbl;
				
				mac_RCChan_NTC();
				fun_RCInit();
				lu8v_RCWork_Mode++;
				
			}
		break;
		case 2:
			if(_rtmrf)
			{
				_rtmrf = 0;
				gu16v_ADC_NTC.byte.byte1 = _tmrbh;
				gu16v_ADC_NTC.byte.byte0 = _tmrbl;
								
				
				lu8v_RCWork_Mode++;
			}
		break;
		case 3:
		{	
			
		    gu16v_Rntc= (u32)3000*gu16v_ADC_REF.U16/(u32)gu16v_ADC_NTC.U16;
			gu16v_Rntc=(u32)gu16v_correction_K.U16*gu16v_Rntc/10000;//用k係數校準			
			fun_Vsen_Calculate();
			
			#ifndef two_decimal
			gu16v_Temp=(gu16v_Temp + 5)/10;//0.1℃
			#endif	
			
			#ifndef dynamic_temp
				if(gu16v_Temp_MAX.U16 < gu16v_Temp)
				{
					gu16v_Temp_MAX.U16 = gu16v_Temp;
				}
				#ifdef two_decimal
				if(gu16v_Temp_MAX.U16 <3200)
				{
					LCD_Display_Lo();//"Lo"
				}
				else if(gu16v_Temp_MAX.U16 >4300)
				{
					LCD_Display_HI();//"HI"
				}	
				else
				{
					LCD_Number_Display(gu16v_Temp_MAX.U16,DOT_POSTION);				
				}					
			#else		
				if(gu16v_Temp_MAX.U16 <320)
				{
					LCD_Display_Lo();//"Lo"
				}
				else if(gu16v_Temp_MAX.U16 >430)
				{
					LCD_Display_HI();//"HI"
				}
				else
				{
					LCD_Number_Display(gu16v_Temp_MAX.U16,DOT_POSTION);				
				}
			#endif						
			if(gu16v_Temp_MAX_Last.U16 == gu16v_Temp_MAX.U16)
			{
				gu8v_RC_Count++;
				if(gu8v_RC_Count > 90)
				{
					gu8v_RC_Count  = 0;
					#ifdef two_decimal
					if((gu16v_Temp_MAX.U16 <3200) || (gu16v_Temp_MAX.U16 >4300))
					{
						gu8v_Beep_Mode = BEEP_1_1_1;
					}
					else
					{
						gu8v_Beep_Mode = BEEP_1;
						gu16v_MemData.U16=gu16v_Temp_MAX.U16;											
					}
					#else
					if((gu16v_Temp_MAX.U16 <320) || (gu16v_Temp_MAX.U16 >430))
					{
						gu8v_Beep_Mode = BEEP_1_1_1;
					}
					else
					{
						gu8v_Beep_Mode = BEEP_1;
						gu16v_MemData.U16=gu16v_Temp_MAX.U16;											
					}					
					#endif					
					gu8v_500msCount = 0;
					lu8v_RCWork_Mode = 4;

					break;
				}
			}
			else
			{
				gu8v_RC_Count = 0;
				gu16v_Temp_MAX_Last = gu16v_Temp_MAX;
			}
			#else				
//			LCD_Number_Display(gu16v_ADC_NTC.U16,0);
			LCD_Number_Display(gu16v_Temp,DOT_POSTION);			
			
			#endif			
			lu8v_RCWork_Mode = 0;
		}
		break;
		case 4:
			if(gu8v_500msCount > 40)
			{
				fun_LCD_Full(0);
				gu8v_500msCount = 0;
				gu8v_SysMode = Halt_Mode;
				
			}
			GCC_NOP();
		
		
		break;
		default:
		break;
	}
	
}


void	fun_RCInit()
{
	_ton 	= 	0;
	GCC_DELAY(100);
	GCC_CLRWDT();
	
	_tmral	=	(65536-16300)%256;//64khz:254ms
	_tmrah	=	(65536-16300)>>8;
	_tmrbl	=	0;
	_tmrbh	=	0;

	_ton 	= 	0;
	_ton 	= 	1;
}

